IF OBJECT_ID('P_EST_SNGPC_ENTRADA_EXCLUIR') IS NOT NULL
BEGIN
	DROP PROCEDURE P_EST_SNGPC_ENTRADA_EXCLUIR
END

GO

CREATE PROCEDURE P_EST_SNGPC_ENTRADA_EXCLUIR(@PCODIGOMOVENTRADA INT,
                                             @CD_EMP            INT,
                                             @CD_USU            INT,
                                             @CD_FILIAL         INT,
                                             @PVERSAO           VARCHAR(20))
AS
     SET NOCOUNT ON;
     DECLARE @CD_LOTE INT;
     DECLARE @QTDE INT;
     DECLARE @SALDOLOTE INT;
     DECLARE @PCODIGOMEDICAMENTO INT;
     DECLARE @SAIDASLOTE  INT;
     DECLARE @ERROR VARCHAR(MAX);
     DECLARE @DT_MOV DATETIME;
    BEGIN TRY
  
       SET @DT_MOV  =
        (
            SELECT DT_MOV
            FROM EST_SNGPC_ENTRADA (NOLOCK)
            WHERE 
              CD_ENT_SNGPC = @PCODIGOMOVENTRADA
        ); 
             
    
        SET @CD_LOTE =
        (
            SELECT CD_LOTE
            FROM EST_SNGPC_ENTRADA (NOLOCK)
            WHERE CD_ENT_SNGPC = @PCODIGOMOVENTRADA
        );
        SET @QTDE =
        (
            SELECT QT_LOTE
            FROM EST_SNGPC_ENTRADA  (NOLOCK)
            WHERE CD_ENT_SNGPC = @PCODIGOMOVENTRADA
        );
        SET @PCODIGOMEDICAMENTO =
        (
            SELECT CD_PROD 
            FROM EST_PROD_EST_SNGPC_LOTE  (NOLOCK)
            WHERE CD_LOTE = @CD_LOTE
        );
        SET  @SALDOLOTE   =
            (
            SELECT QT_LOTE
            FROM
               EST_PROD_EST_SNGPC_LOTE_CPL
            WHERE
               CD_LOTE = @CD_LOTE
               AND CD_FILIAL =@CD_FILIAL
            )  
            
            
        SET @SAIDASLOTE  =
          (SELECT               
           COUNT(A.CD_LOTE)       
          FROM                 
             EST_SNGPC_SAIDA (NOLOCK) A  
         
          WHERE 
            A.CD_LOTE        =  @CD_LOTE
            AND A.DT_MOV     >= @DT_MOV
            AND A.CD_FILIAL  = @CD_FILIAL
          
          )
        IF(@PCODIGOMEDICAMENTO IS NOT NULL
           AND @CD_LOTE IS NOT NULL)
            BEGIN
                IF ( @SAIDASLOTE > 0 ) 
                BEGIN
                  RAISERROR('MOVIMENTAO NAO PODE SER EXCLUIDA JA FORAM FEITAS VENDAS DO LOTE ', 16, 1);
                END;     
                
               IF ( (@SALDOLOTE - @QTDE) < 0) 
                BEGIN
                   RAISERROR('MOVIMENTAO NAO PODE SER EXCLUIDA QUANTIDADE INSUFICIENTE', 16, 1);
                END 
              
                DELETE FROM EST_SNGPC_ENTRADA
                WHERE CD_ENT_SNGPC = @PCODIGOMOVENTRADA
                      AND CD_EMP = @CD_EMP
                      AND CD_FILIAL = @CD_FILIAL;
                INSERT INTO SNGPC_HIST_MOV_LOTE
                (CD_EMP,
                 CD_FILIAL,
                 CD_PROD,
                 LOTE,
                 TIPO_MOV,
                 CD_MOV,
                 DT_MOV,
                 CD_USU,
                 QT_MOV,
                 VERSAO
                )
                VALUES
                (@CD_EMP,
                 @CD_FILIAL,
                 @PCODIGOMEDICAMENTO,
                 @CD_LOTE,
                 'EXCLUSAO ENTRADA',
                 @PCODIGOMOVENTRADA,
                 GETDATE(),
                 @CD_USU,
                 @QTDE,
                 @PVERSAO
                );
                UPDATE EST_PROD_EST_SNGPC_LOTE_CPL
                  SET
                      QT_LOTE = (QT_LOTE - @QTDE)
                WHERE CD_EMP = @CD_EMP
                      AND CD_FILIAL = @CD_FILIAL
                      AND CD_LOTE = @CD_LOTE
                      AND (QT_LOTE - @QTDE) >= 0;
            END;
    END TRY
    BEGIN CATCH
        BEGIN TRY
            IF @@TRANCOUNT > 0
                ROLLBACK;
        END TRY
        BEGIN CATCH
        END CATCH;
        SET @ERROR = ERROR_MESSAGE();
        RAISERROR(@ERROR, 16, 1);
    END CATCH;



GO